@echo off & SETLOCAL EnableDelayedExpansion & TITLE Chrono Trigger - MSU-1 Music

set INPUT="%~1"
set OUTPUT="%~2"

set /A SIZE=0x400000

set SOURCE="src\chrono_msu1.asm"
set BASS="bass\bass.exe"

:check
if %INPUT%=="" (
    echo [ERROR] No ROM^^! Drag and drop a ROM into this script.
    goto failed
)

if not exist %INPUT% (
    echo [ERROR] ROM not found^^!
    goto failed
)

if %OUTPUT%=="" set OUTPUT="chrono_msu1.sfc"

if not exist %SOURCE% (
    echo [ERROR] Source code not found^^!
    goto failed
)

if not exist %BASS% (
    echo [ERROR] bass not found^^!
    goto failed
)

if exist "%SystemRoot%\system32\WindowsPowerShell\v1.0\powershell.exe" (
    set "PS=powershell -nologo -noprofile -noninteractive -command"
)

:copy
echo [*] Copying ROM...

copy /V /Y %INPUT% /B %OUTPUT% /B > nul 2>&1

if %ERRORLEVEL% NEQ 0 goto error

:scan
echo [*] Scanning ROM...

if defined PS (
    %PS% "& {"^
        "$rominfo = [System.IO.FileInfo](\"%OUTPUT%\");"^
        "if (($rominfo.Length -band 0x3FF) -eq 0x200) {"^
            "$data = [System.IO.File]::ReadAllBytes(\"%OUTPUT%\");"^
            "$data = $data[0x200..($data.Length - 1)];"^
            "[System.IO.File]::WriteAllBytes(\"%OUTPUT%\", $data);"^
        "}"^
        "exit 0;"^
    "}"

    if !ERRORLEVEL! NEQ 0 goto error
)

for %%f in (%OUTPUT%) do (
    if %%~zf NEQ %SIZE% (
        echo [ERROR] Invalid ROM^^!
        goto error
    )
)

if defined PS (
    %PS% "& {"^
        "[int[]] $offsets = @("^
            "0x070004,"^
            "0x00FF10,"^
            "0x070409,"^
            "0x070A4B,"^
            "0x02CBE0,"^
            "0x0335AF,"^
            "0x003CC6,"^
            "0x000D00,"^
            "0x073306"^
        ");"^
        "[byte[][]] $signatures = @("^
            "@(0x4C,0x40,0x01,0xEA),"^
            "@(0x5C,0x00,0x05,0x00),"^
            "@(0xA9,0xE0,0x85,0x84),"^
            "@(0xBF,0x1D,0x24,0xC7),"^
            "@(0xAF,0x43,0x21,0x00,0x29,0x0F,0xF0,0xF8),"^
            "@(0xAD,0x80,0x43,0x21,0x29,0x0F,0xF0,0xF9),"^
            "@(0xAD,0x43,0x21,0x29,0x0F),"^
            "@(0xA9,0x00,0x80,0x14),"^
            "@(0x1E)"^
        ");"^
        "function Check([System.IO.FileStream] $rom) {"^
            "for ($i = 0; $i -lt $offsets.Length; $i++) {"^
                "$offset = $offsets[$i];"^
                "$signature = $signatures[$i];"^
                "$data = New-Object byte[] $signature.Length;"^
                "[void]$rom.Seek($offset, [System.IO.SeekOrigin]::Begin);"^
                "[void]$rom.Read($data, 0, $signature.Length);"^
                "if (@(Compare-Object $data $signature -SyncWindow 0).Length -ne 0) {"^
                    "return 1;"^
                "}"^
            "}"^
            "return 0;"^
        "}"^
        "$rominfo = [System.IO.FileInfo](\"%OUTPUT%\");"^
        "$rom = $rominfo.OpenRead();"^
        "$result = Check $rom;"^
        "$rom.Close();"^
        "exit $result;"^
    "}"

    if !ERRORLEVEL! NEQ 0 (
        echo [ERROR] ROM byte signature mismatch^^! Please contact this hack's author.
        goto error
    )

    %PS% "& {"^
        "[int[]] $addresses = @("^
            "0x0D5D20,"^
            "0x0DF9D0"^
        ");"^
        "[int[]] $sizes = @("^
            "422,"^
            "1584"^
        ");"^
        "[byte[]] $values = @("^
            "0xFF,"^
            "0xFF"^
        ");"^
        "function Check([System.IO.FileStream] $rom) {"^
            "for ($i = 0; $i -lt $addresses.Length; $i++) {"^
                "$address = $addresses[$i];"^
                "$size = $sizes[$i];"^
                "$value = $values[$i];"^
                "$data = New-Object byte[] $size;"^
                "[void]$rom.Seek($address, [System.IO.SeekOrigin]::Begin);"^
                "[void]$rom.Read($data, 0, $size);"^
                "foreach ($byte in $data) {"^
                    "if ($byte -ne $value) { return 1; }"^
                "}"^
            "}"^
            "return 0;"^
        "}"^
        "$rominfo = [System.IO.FileInfo](\"%OUTPUT%\");"^
        "$rom = $rominfo.OpenRead();"^
        "$result = Check $rom;"^
        "$rom.Close();"^
        "exit $result;"^
    "}"

    if !ERRORLEVEL! NEQ 0 (
        echo [ERROR] Required ROM address spaces are not free^^! Please contact this hack's author.
        goto error
    )
)

:assemble
echo [*] Assembling...

if defined DEFINE for %%m in (%DEFINE%) do set macros=!macros! -d %%m

%BASS% %macros% -o %OUTPUT% %SOURCE%

if %ERRORLEVEL% NEQ 0 goto error

:checksum
if exist "checksum.exe" (
    echo [*] Calculating checksum...

    checksum -t %OUTPUT%

    if !ERRORLEVEL! NEQ 0 goto error
)

echo.

if not exist "flips.exe" goto confirm_msu

:confirm_bps
set /P do_bps="Create BPS patch? [Y]es/[N]o: "

if "%do_bps%"=="y" goto bps
if "%do_bps%"=="Y" goto bps
if "%do_bps%"=="n" goto confirm_msu
if "%do_bps%"=="N" goto confirm_msu

goto confirm_bps

:bps
echo.
echo [*] Creating BPS patch...

flips -c -b %INPUT% %OUTPUT% > nul 2>&1

if %ERRORLEVEL% NEQ 0 goto error

echo.

:confirm_msu
set /P do_msu="Create MSU-1 file? [Y]es/[N]o: "

if "%do_msu%"=="y" goto msu
if "%do_msu%"=="Y" goto msu
if "%do_msu%"=="n" goto success
if "%do_msu%"=="N" goto success

goto confirm_msu

:msu
echo.
echo [*] Creating MSU-1 file...

for %%f in (%OUTPUT%) do type NUL > "%%~nf.msu"

if %ERRORLEVEL% NEQ 0 goto error

:success
echo.
echo ***ALL DONE***

set /A exit_code=0

:exit
echo.
pause

exit %exit_code%

:failed
set /A exit_code=1
goto exit

:error
echo.
echo ***ERROR***

del /F /Q %OUTPUT% > nul 2>&1

set /A exit_code=2
goto exit
